# 画面設計書 14-SQL All Executions（SQL実行一覧）

## 概要

本ドキュメントは、Apache Spark Application UIのSQL / DataFrameタブにあるSQL実行一覧画面の設計内容を記述する。本画面は全SQL/DataFrame実行をRunning/Completed/Failedに分類してページングテーブルで表示する。

### 本画面の処理概要

**業務上の目的・背景**：Spark SQLやDataFrame APIを使用したクエリの実行状況を一元的に把握するための画面である。データエンジニアやDBA相当の運用者は、本画面により実行中・完了済み・失敗したSQL/DataFrame実行の一覧を確認でき、パフォーマンスの問題があるクエリの特定や、障害発生時の失敗クエリの迅速な把握が可能となる。Sub Executionグループ化機能により、親子関係のあるSQL実行を階層的に表示することもできる。

**画面へのアクセス方法**：SparkUIのタブバーにある「SQL / DataFrame」タブをクリックすることでアクセスする。SQLモジュールを使用しているアプリケーションでのみタブが表示される。

**主要な操作・処理内容**：
1. Running/Completed/Failedのセクション別にSQL実行一覧を確認する
2. ページングテーブルでページ切り替え・ページサイズ変更を行う
3. カラムヘッダクリックでソート（ID/Query ID/Description/Submitted/Duration等）を切り替える
4. 実行IDリンクをクリックしてSQL実行詳細画面（No.15）へ遷移する
5. Job IDリンクをクリックしてジョブ詳細画面（No.2）へ遷移する
6. Description内の「+details」でSQL文の詳細を展開表示する
7. Sub Execution表示（設定有効時）で子実行の一覧を確認する

**画面遷移**：SparkUIのタブバーから直接アクセスする。本画面からSQL実行詳細画面（No.15）およびジョブ詳細画面（No.2）へ遷移可能。

**権限による表示制御**：SQLモジュール未使用の場合、SQL / DataFrameタブ自体が表示されない。ACL設定が有効な場合、閲覧権限が必要。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | 全SQL/DataFrame実行をRunning/Completed/Failedに分類してページングテーブル表示する主処理 |
| 19 | SQLパーサー | 補助機能 | SQL実行の記述内容（SQL文）を解析結果とともに表示 |
| 20 | Catalystオプティマイザ | 補助機能 | SQL実行の最適化時間・物理プラン情報を参照して表示 |
| 95 | KVStore | API連携 | SQLAppStatusStore経由でSQL実行データを非同期取得 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/SQL/`
- パラメータ（ページング・ソート用）:
  - `{tag}.page` - ページ番号（tag: running/completed/failed）
  - `{tag}.sort` - ソートカラム
  - `{tag}.desc` - 降順フラグ
  - `{tag}.pageSize` - ページサイズ
- 例: `/SQL/?running.page=1&running.sort=ID&running.desc=false`

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|------|------|------|
| {tag}.page | 入力（URLパラメータ） | Int | 任意 | ページ番号。デフォルト: 1 |
| {tag}.sort | 入力（URLパラメータ） | String | 任意 | ソートカラム。デフォルト: "ID" |
| {tag}.desc | 入力（URLパラメータ） | Boolean | 任意 | 降順フラグ |
| {tag}.pageSize | 入力（URLパラメータ） | Int | 任意 | ページサイズ |

## 表示項目

### サマリーセクション

| 項目名 | データ型 | 説明 |
|--------|----------|------|
| Running Queries | Int | 実行中のクエリ数 |
| Completed Queries | Int | 完了したクエリ数 |
| Failed Queries | Int | 失敗したクエリ数 |

### SQL実行テーブル（Running/Completed/Failed共通）

| 項目名 | データ型 | 説明 | ソート |
|--------|----------|------|--------|
| ID | Long | SQL実行ID | 可 |
| Query ID | String | クエリID（設定時のみ）。N/Aの場合あり | 可 |
| Description | String | SQL実行の説明。「+details」でSQL文・詳細展開 | 可 |
| Submitted | Date | 実行開始日時 | 可 |
| Duration | Long | 実行時間（投入から完了まで、実行中は経過時間） | 可 |
| Running Job IDs | Seq[Int] | 実行中のジョブID一覧（Runningテーブルのみ） | 可 |
| Succeeded Job IDs | Seq[Int] | 成功したジョブID一覧 | 可 |
| Failed Job IDs | Seq[Int] | 失敗したジョブID一覧（Running/Failedテーブル） | 可 |
| Error Message | String | エラーメッセージ（Failedテーブルのみ） | 可 |
| Sub Execution IDs | Seq[Long] | 子実行ID一覧（UI_SQL_GROUP_SUB_EXECUTION_ENABLED時のみ） | 可 |

## イベント仕様

### 1-ページ切り替え

ページングテーブルのページナビゲーションリンクをクリックすると、対象セクション（running/completed/failed）のページが切り替わる。URLパラメータとしてページ番号が付与される。

### 2-ソート切り替え

テーブルヘッダのカラムをクリックすると、該当カラムでソートが切り替わる。同一カラムの再クリックで昇順/降順が反転する。

### 3-実行ID リンクク

Description列のリンクをクリックすると、SQL実行詳細画面（/SQL/execution/?id={executionId}）へ遷移する。

### 4-Job ID リンククリック

Job ID列のリンクをクリックすると、ジョブ詳細画面（/jobs/job/?id={jobId}）へ遷移する。

### 5-Details展開

Description列の「+details」をクリックすると、SQL文の詳細テキストが折りたたみ表示される。

### 6-セクション折りたたみ

Running/Completed/Failedの各セクションヘッダをクリックすると、該当セクションのテーブルが折りたたみ/展開される。

### 7-Sub Execution展開

Sub Execution IDs列の「+details」をクリックすると、子実行の詳細テーブルが展開表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | - | SELECT | SQLAppStatusStore.executionsList()でKVStoreからSQL実行データを取得 |

本画面はデータベースへの更新操作を行わない。KVStore経由で読み取り専用のアクセスを行う。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | "Error while rendering execution table: {exception}" | ページングテーブルのレンダリング中に例外が発生した場合 |

## 例外処理

- ページングパラメータの不正値: IllegalArgumentExceptionまたはIndexOutOfBoundsExceptionをキャッチし、エラーメッセージをテーブル内に表示
- SQL実行データなし: 各セクション（Running/Completed/Failed）のデータが空の場合、該当セクションは表示されない

## 備考

- SQLTabのデフォルト画面として表示される
- spark.ui.sql.groupSubExecutionEnabled（デフォルト: false）が有効の場合、rootExecutionIdに基づいてSub Executionをグループ化して表示する
- ページタイトルは「SQL / DataFrame」
- displayOrderは0（タブの表示順序が最初）
- SQLAppStatusStoreからのデータ取得はexecutionsList()メソッドで行われ、実行IDの昇順で返される

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SQLExecutionUIData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | SQLExecutionUIDataクラスのフィールド（executionId, rootExecutionId, description, details, physicalPlanDescription, modifiedConfigs, submissionTime, completionTime, errorMessage, jobs, executionStatus等）を確認 |
| 1-2 | ExecutionTableRowData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | 行507-513: テーブル行データクラス。duration, runningJobData, completedJobData, failedJobData, subExecutionDataを保持 |

**読解のコツ**: SQLExecutionUIDataのjobsフィールドはMap[Int, JobExecutionStatus]型で、ジョブIDと実行ステータスのマッピングを保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | 行24-40: SQLTabクラス。AllExecutionsPageとExecutionPageを登録 |
| 2-2 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | 行35-38: クラス定義。WebUIPage("")でデフォルトページ |

**主要処理フロー**:
1. **行41**: currentTimeを取得
2. **行42-44**: running/completed/failedの3つのArrayBufferを初期化
3. **行48-72**: sqlStore.executionsList()でデータ取得し、ステータス別に分類。Sub Execution対応のグループ化処理
4. **行74-157**: 各セクション（Running/Completed/Failed）のテーブルHTML生成
5. **行164-192**: サマリー（クエリ数の統計リンク）生成
6. **行194**: UIUtils.headerSparkPageでページ全体をラップ

#### Step 3: ページングテーブルを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | 行240-504: ExecutionPagedTableクラス。PagedTableを継承し、ソート・ページング・行レンダリングを実装 |
| 3-2 | AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | 行516-592: ExecutionDataSourceクラス。データのソートとスライシングを担当 |

### プログラム呼び出し階層図

```
SQLTab [行24]
    |
    +-- AllExecutionsPage (WebUIPage("")) [行33]
            |
            +-- render(request) [行40]
                    |
                    +-- sqlStore.executionsList() [行48]
                    |       |
                    |       +-- SQLAppStatusStore -> KVStore
                    |
                    +-- Running/Completed/Failed分類 [行49-72]
                    |       |
                    |       +-- Sub Executionグループ化（UI_SQL_GROUP_SUB_EXECUTION_ENABLED時）
                    |
                    +-- executionsTable() [行79-88, 105-114, 131-141]
                    |       |
                    |       +-- ExecutionPagedTable [行214-227]
                    |               |
                    |               +-- ExecutionDataSource [行260-269]
                    |               |       |
                    |               |       +-- executionRow() -> ソート -> スライス
                    |               |
                    |               +-- headers / row メソッド
                    |
                    +-- サマリーHTML生成 [行164-192]
                    |
                    +-- UIUtils.headerSparkPage() [行194]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

URLパラメータ ────────────> AllExecutionsPage.render()
(page, sort, desc,                 |
 pageSize)                         +---> SQLAppStatusStore
                                   |     .executionsList() ────────> Seq[SQLExecutionUIData]
                                   |           |
                                   +---> ステータス分類
                                   |     (RUNNING/COMPLETED/FAILED)
                                   |           |
                                   +---> Sub Executionグループ化
                                   |           |
                                   +---> ExecutionPagedTable
                                   |     (ソート・ページング)
                                   |           |
                                   +---> サマリー + テーブルHTML ──> 完成ページHTML
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| AllExecutionsPage.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` | ソース | メイン画面ページクラス・テーブルクラス |
| SQLTab.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` | ソース | SQLタブ定義・ページ登録 |
| SQLAppStatusStore.scala | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | ソース | SQL実行データストア |
| SQLExecutionUIData | `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLAppStatusStore.scala` | ソース | SQL実行UIデータモデル |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | UI共通ユーティリティ |
| PagedTable.scala | `core/src/main/scala/org/apache/spark/ui/PagedTable.scala` | ソース | ページングテーブル基底クラス |
